

 
; Soft start for frequency (50 or 60Hz) requires 220VAC supply
; Current detection included 
; trailing edge phase control using Mosfet in diode bridge

; Soft start smooth voltage set by voltage at VR2 at AN2
; mains current measured at AN1
; Mosfet stepup gate voltage generated by clockout
; Mosfet on/off via GP0
; Relay on via GP5
; Zero voltage crossing of mains at GP3

;Test option 1 Phase initial setting based on VR1
;Test option 2. check current. If over ~10A hold increase in ramp
;Test option 3. Fixed soft start rate
;Test Option 4. if soft start is running, and relay off, then no switch off with low current (prevents halted start)

	ERRORLEVEL -302
	ERRORLEVEL -306

	    list      p=12F617         ; list directive to define processor
     #include <p12F617.inc>        ; processor specific variable definitions


     __CONFIG   _CP_OFF & _BOR_ON & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_CLKOUT & _IOSCFS_4MHZ & _WRT_OFF

; RAM 
STORE1			equ	H'20'	; delay counter	;
STORE2			equ	H'21'	; delay counter
TEMP			equ	H'22'	; temporary working in interrupt only ***
CURRENT_H		equ	H'23'	; current flow ms byte
CURRENT_L		equ	H'24'	; current flow ls byte
SMOOTH_SET		equ	H'25'	; amount of steps of soft start for phase control
SOFT			equ	H'26'	; soft start flag
RAMP			equ	H'27'	; soft start ramp up of phase
COUNT			equ	H'28'	; counter for phase setting reading
RATE			equ	H'29'	; soft start rate
TEMP_NI			equ	H'2A'	; temporary working for non interrupt use
STORED0			equ	H'2B'	; stored values for current output offset MS byte
STORED1			equ	H'2C'	; stored values for current output offset LS byte
VALUEI			equ	H'2D'	; working value in current comparison
STORE3			equ	H'2E'	; delay counter
TIMER			equ	H'2F'	; timer for between relay on and Mosfet off
STO_TMR1H		equ	H'30'	; timer 1 store ms byte
STO_TMR1L		equ	H'31'	; timer 1 store ls byte
PLUS			equ	H'32'	; interrupt edge positive or negative
TEMPX			equ	H'33'	; temporary
INT_COUNT		equ	H'34'	; edge counter for zero crossing
OFF_RUN			equ	H'35'	; offset A/D loops

; All banks RAM
W_TMP			equ	H'70'	; temporary store for w in interrupt
STATUS_TMP		equ	H'71'	; temporary store of status in interrupt 
CURRENT_STALL	equ	H'72'	; stall ramp increase when current limit is reached ms byte (only bits 0 and 1)
CURRENT_STALL1	equ	H'73'	; stall ramp increase when current limit is reached ls byte (bits 0-7_

; DATA (4 blocks)
DATA1ms			equ	H'78'	; data byte 1 ms 
DATA1ls			equ	H'79'	; data byte 1 ls
; DATA2,3,4 not used but included as there are in the 4 blocks of data
DATA2ms			equ	H'7A'	; data 
DATA2ls			equ	H'7B'	; data
DATA3ms			equ	H'7C'	; data 
DATA3ls			equ	H'7D'	; data
DATA4ms			equ	H'7E'	; data 
DATA4ls			equ	H'7F'	; data
;___________________________________________________________

; initial values
	org	H'600'		; start address of where data memory is stored
; DATA1ms
	DE 	H'00' 		; Initially set at 16mV (DC offset from IC2)
; DATA1ls
	DE	H'00'		; 

; ******************************************************************

; start at memory 0

	org		0				; reset vector
	goto	MAIN
; interrupt vector
	org		4
INTERRUPT
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP		; status in status_tmp  
	bcf		STATUS,RP0		; select memory bank 0

; check which interrupt	
RUN	
; if RELAY on and TIMER cleared, switch off Mosfet gate
	btfss 	GPIO,5
	goto	SELECT
	movf	TIMER,w
	btfss	STATUS,Z
	goto	SELECT
	bcf		GPIO,0
	bcf		INTCON,GPIF		; flag cleared
	bcf		INTCON,T0IF		; flag cleared
	goto	RECLAIM

SELECT 
	btfsc	INTCON,T0IF		; timer 0 interrupt flag
	goto	TIM0			;	
	btfss	INTCON,GPIF		; GP3 port change interrupt flag 
	goto	RECLAIM

EDGE
	movf	TIMER,w
	btfss	STATUS,Z		; if zero bypass decrement
	decfsz	TIMER,f
	
;  (GP3)	
	movf	GPIO,w			; clear mismatch
	bcf		INTCON,GPIF		; flag cleared
; read and clear timer 1
	bcf		T1CON,0			; timer 1 off
	movf	TMR1H,w
	movwf	STO_TMR1H
	clrf	TMR1H
	clrf	TMR1L
	bsf		T1CON,0			; timer1 on

;  Adjust initial phase. If SOFT and RAMP are zero, use 0 for ramp
	movf	SOFT,w
	btfss	STATUS,Z
	goto	MOSFET_ON
	movf	RAMP,w
	btfss	STATUS,Z
	goto	MOSFET_ON
	
	bcf		GPIO,0			; gate off at bit 0 (GP0)
	movlw	D'0'
	goto	PREL2

MOSFET_ON
	
; check if timer1 is within the range of (11-12ms) and (~7ms). <HB00 and >H600 
	movf	STO_TMR1H,w		; ms byte 
	sublw	H'B'
	btfss	STATUS,C		; if clear then greater than B00
	goto	TIM0			; Mosfet off
	movf	STO_TMR1H,w
	sublw	H'6'
	btfsc	STATUS,C		; if set then less than 6
	goto	TIM0

; Mosfet on with GPIO,0 
	bsf		GPIO,0			; gate on at bit 0 (GP0)

BY_ON
; if relay is off (GPIO,5 low), run soft start
	btfsc	GPIO,5
	goto	PREL
; and if soft start is on, continue run soft start 
	btfss	SOFT,0			; soft start flag set when running
	goto	PREL

; If relay is on and RAMP is clear, bypass incrementing RAMP
	btfss	GPIO,5			; check relay
	goto	INC_RAMP		; not on so increment
	movf	RAMP,w
	btfsc	STATUS,Z		; if zero then bypass increment
	goto	PREL

INC_RAMP
; SMOOTH_SET is the value set by VR1 for soft start rate
; if 0, use bit 2 in INT_COUNT and RATE=2 for one increment each loop 
	movf	SMOOTH_SET,w
	btfss 	STATUS,Z
	goto	NEXT1	
; count interrupts to bypass increasing ramp
	btfss	INT_COUNT,2
	goto	BY_PHASE_CHNG
	clrf 	INT_COUNT
	movlw	D'2'
	goto	RATE_LP
NEXT1
; if SMOOTH_SET is 1 use INT_COUNT,1 and RATE=2
	movf	SMOOTH_SET,w
	xorlw	D'1'
	btfss	STATUS,Z
	goto	NEXT2
; count interrupts to bypass increasing ramp
	btfss	INT_COUNT,1
	goto	BY_PHASE_CHNG
	clrf 	INT_COUNT
	movlw	D'2'
	goto	RATE_LP

NEXT2
; if SMOOTH_SET is 2 use INT_COUNT,0 and RATE=2
	movf	SMOOTH_SET,w
	xorlw	D'2'
	btfss	STATUS,Z
	goto	NEXT3
; count interrupts to bypass increasing ramp
	btfss	INT_COUNT,0
	goto	BY_PHASE_CHNG
	clrf 	INT_COUNT
	movlw	D'2'
	goto	RATE_LP

NEXT3
; if SMOOTH_SET is 3 no interrupt count and RATE=2
	movf	SMOOTH_SET,w
	xorlw	D'3'
	btfss	STATUS,Z
	goto	NEXT4
; bypass interrupt count
	movlw	D'2'
	goto	RATE_LP

NEXT4
; if SMOOTH_SET is 4 use no interrupt count and RATE=3
	movf	SMOOTH_SET,w
	xorlw	D'4'
	btfss	STATUS,Z
	goto	NEXT5
; bypass interrupt count
	movlw	D'3'
	goto	RATE_LP

NEXT5
	movlw	D'4'

RATE_LP
; increase according to SMOOTH_SET
	movwf	RATE
RATE_LOOP
	decfsz	RATE,F
	goto	DO_INC
	goto	PREL
DO_INC
	incf	RAMP,w			
	btfsc	STATUS,Z		; if over, set at FF
	movlw	H'FF'
	movwf	RAMP
	goto	RATE_LOOP

; preload timer0 with 255 minus the required phase (SMOOTH_SET plus RAMP)
PREL
	movf	SMOOTH_SET,w
PREL1
	addwf	RAMP,w
	btfsc	STATUS,C		; if over then set at FF
	movlw	H'FF'
PREL2
	movwf	TEMP
	comf	TEMP,w
	movwf	TMR0
	nop
	bcf		INTCON,T0IF

; when TEMP is >191 then switch on relay and clear SOFT flag
; 191 x 64us = 12.224ms slightly longer than 10ms (156 x 64us) for 50Hz mains edge to edge
	movf	TEMP,w
	sublw	D'191'
	btfsc	STATUS,C
	goto	CLR_SOFT
; relay on, soft cleared
	btfsc	GPIO,5			; if relay already on don't set value in timer
	goto	CLR_SOFT
	movlw	D'5'
	movwf	TIMER			; start interrupt timer for time between relay on and Mosfet off
	bsf		GPIO,5			; relay on

CLR_SOFT
; clear SOFT when TEMP is FF
	movf	TEMP,w
	xorlw	H'FF'
	btfsc	STATUS,Z
	clrf	SOFT
	incf	TEMP,w
	btfsc	STATUS,Z
	clrf	SOFT
	goto	RECLAIM

TIM0; prevent timer0 overflowing
	clrf	TMR0
	nop
	bcf		INTCON,T0IF

; Mosfet off with GPIO,0 low

	bcf		GPIO,0			; gate off at bit 0 (GP0)

; end of interrupt reclaim w and status 

RECLAIM
	swapf	STATUS_TMP,w	; status temp storage to w
	movwf	STATUS			; w to status register
	swapf	W_TMP,f			; swap upper and lower 4-bits in w_tmp
	swapf  	W_TMP,w			; swap bits and into w register
	retfie					; return from interrupt

BY_PHASE_CHNG
	incf 	INT_COUNT,f
	clrw
	goto	PREL1

; ***********************************************************
		
MAIN
; set oscillator calibration
	bsf		STATUS,RP0		; bank 1
    movlw   0x00      		; set oscillator to factory calibrated frequency 
    movwf   OSCTUNE
	bcf		STATUS,RP0
; set inputs/outputs
	movlw	B'00000000'
	movwf	GPIO			; ports low
	movlw	B'00000111'		; comparators off
	movwf	CMCON0
	bsf		STATUS,RP0		; select memory bank 1
	movlw	B'00000000'		; pullups off
	movwf	WPU
	movlw	B'00001110'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	movlw	B'10000101'		; settings (pullups disabled) timer0 /64 prescaler (bit 6: 1 is rising edge, 0 is falling edge interrupt) 4V and 1V triggers
	movwf	OPTION_REG
	bsf		IOC,3			; bit 3 GPIO3 interrupt on change
; analog inputs, A/D
	movlw	B'01010110'
	movwf	ANSEL			; digital I/O and analog 
;Timer1
	bcf		STATUS,RP0		; select memory bank 0
	movlw	B'00100001'
	movwf	T1CON			; divide by 4 for 4uS per count

;bits 3-2 CHS1:CHS0: Analog Channel Select bits
	movlw	B'00000100'		; channel 1, left justified, VDD ref etc
;01 = Channel 01 (AN1) CURRENT
;10 = Channel 02 (AN2) smooth setting

	movwf	ADCON0
	bsf		ADCON0,0		; A/D on

; Startup timer

STRT_DEL
;
	movlw	D'255'			; delay value 
	call	DEL_MORE

;initial
	clrf 	INT_COUNT		; clear interrupt zero crossing counter
	clrf	RAMP			; actual phase value (SMOOTH_SET plus RAMP)
	clrf	SOFT			; soft start flag
	clrf	TIMER
	movlw	D'25'
	movwf	COUNT			; phase setting reading counter

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; test Mosfet drive
;TMD
; Mosfet on with GPIO,0 
;	bsf		GPIO,0			; gate on at bit 0 (GP0)

;	movlw   D'14'
;	call	DEL_MORE
; Mosfet off with GPIO,0 an input

;	bcf		GPIO,0			; gate off at bit 0 (GP0)
;	movlw   D'14'
;	call	DEL_MORE
;	goto	TMD				; test Mosfet drive
; end test Mosfet Drive
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; read VR1  

	call	SMOOTH_SETTING
	goto	ALLOW_INTERUPTS
;
;..................................................................
;subroutine

SMOOTH_SETTING ; bits 3-2 CHS1:CHS0: Analog Channel Select bits
;10 = Channel 02 (AN2) 
; smooth setting
	bcf		ADCON0,2		; 
	bsf		ADCON0,3		; channel 2
	call	DELAYX
	call	ACQUIRE_ADP
	movf	ADRESH,w
	movwf	TEMP_NI
	movwf	TEMPX

; allows rates of soft start depending on smooth setting

; Fully clockwise sets offset from rectifier

; divide by 32 
	bcf		STATUS,C
	rrf		TEMPX,f
	bcf		STATUS,C
	rrf		TEMPX,f
	bcf		STATUS,C
	rrf		TEMPX,f
	bcf		STATUS,C
	rrf		TEMPX,f
	bcf		STATUS,C
	rrf		TEMPX,w
	
	movwf	SMOOTH_SET
	return
;..............................................................

ALLOW_INTERUPTS
; firstly clear timer1
	bcf		T1CON,0		; timer 1 off
	clrf	TMR1H
	clrf	TMR1L
	bsf		T1CON,0		; timer1 on
; Interrupts

	bsf		INTCON,GPIE	; enable port change interrrupt
	bcf		INTCON,GPIF	; port change flag	
	bsf		INTCON,T0IE	; timer 0 overflow
	bcf		INTCON,T0IF	; timer 0 flag 
	bsf 	INTCON,GIE	; set global interrupt enable 

CYCLE

; read VR1 
; bits 3-2 CHS1:CHS0: Analog Channel Select bits

; Read current 
; 
;01 = Channel 1 (AN1) 
	bsf		ADCON0,2
	bcf		ADCON0,3		; channel 1
	call	DELAYX
	call	ACQUIRE_ADI
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w	; ls bits
	bcf 	INTCON,GIE	; clear global interrupt enable. so ls and ms bytes aren't affected  
	bcf		STATUS,RP0	; select memory bank 0	
	movwf	CURRENT_L	; store LS bits
	movwf	CURRENT_STALL1	; ls byte
	movf	ADRESH,w
	movwf 	CURRENT_H
	movwf	CURRENT_STALL	; used for stalling ramp increase at current limit
	bsf 	INTCON,GIE	; allow global interrupt enable 

SMOOTH_CHECK

; only check once every 25 counts
	movf	COUNT,w
	btfsc	STATUS,Z
	goto	DO_SMOOTH_CHECK	; when 0 
	decf	COUNT,F			; not zero so decrement each time until reaches 0
	goto	BY_STORE

DO_SMOOTH_CHECK
	movlw	D'25'
	movwf	COUNT			; start count each 25 times

	call	SMOOTH_SETTING	; get VR1 value

	movf	TEMP_NI,w		; if >253. store current flow reading from IC2 output (includes IC2 offset) 
	sublw	D'253'
	btfsc	STATUS,C
	goto	BY_STORE

;////////////////////////////////////////////////////////
DO_OFFSET
	bcf 	INTCON,GIE		; clear global interrupt enable 
	clrf	SOFT
	clrf	RAMP
	bcf		GPIO,5			; relay off	
	bcf		GPIO,7			; Mosfet off

	movlw	D'5'
	movwf	OFF_RUN			; offset A/D loops 

OFFSET_LOOP
	movf	OFF_RUN,w
	btfss	STATUS,Z
	goto	OFF_LP
NO_RUN
	goto	NO_RUN			; stop storing so at switch off will not be storing

OFF_LP
	decf	OFF_RUN,f
	call	DELAYms
	call	SMOOTH_SETTING	; get VR1 value

	movf	TEMP_NI,w		; if >253. store current flow reading from IC2 output (includes IC2 offset) 
	sublw	D'253'
	btfsc	STATUS,C
	goto	ALLOW_INTERUPTS

; Get current offset
; compare with stored

; get stored setting (READ)
	call	READ			; read stored data
	movwf	STORED0
	call	READ2
	movwf	STORED1

; compare
	movf	STORED0,w		; high byte
	xorwf	CURRENT_H,w		; compare
	btfss	STATUS,Z		; if zero check low byte
	goto	STORE			; not the same so store
	movf	STORED1,w		; low byte
	xorwf	CURRENT_L,w		; compare
	btfsc	STATUS,Z
	goto	OFFSET_LOOP		; both the same so bypass store

STORE
; place into stored Flash memory (WRITE)
	movlw	H'3F'
	movwf	DATA1ms
	movwf	DATA2ms
	movf	CURRENT_H,w
	movwf	DATA1ls
	movf	CURRENT_L,w
	movwf	DATA2ls
	call 	WRITE			; write to memory
	goto	OFFSET_LOOP

;//////////////////////////////////////////////////////////////

BY_STORE

; check for low current. If low, switch off relay. Clear SOFT flag 
; If high, run soft start if not already done

; subtract offset from current reading	
; get stored offset first
	call	READ			; read stored data
	movwf	STORED0			; most significant bits
	call	READ2
	movwf	STORED1			; least significant byte
; subtract from current

	movf	STORED0,w		; high byte
	subwf	CURRENT_H,f		; subtraction
	movf	STORED1,w		; low byte
	subwf	CURRENT_L,f		; subtraction
	btfss	STATUS,C
	decf	CURRENT_H,f		; reduce high byte subtraction if carry	
	btfsc	CURRENT_H,7		; if set then a negative value so switch off
	goto	SWITCH_OFF

; *** Test Option ; if soft start is running, and relay off, then no switch off
; prevents soft start stopping and starting during soft start if current too low
;	btfss	SOFT,0			; if set check relay
;	goto	CMPRE
;	btfss 	GPIO,5			; if relay on can check again for off current
;	goto	CYCLE
; end test option 

CMPRE
; compare against current values
	movlw	H'00'
	subwf	CURRENT_H,w		; subtraction
	movwf	VALUEI			; keep subtraction
	movlw	H'02'			; low byte
	subwf	CURRENT_L,w		; subtraction
	btfss	STATUS,C
	decf	VALUEI,f		; reduce high byte subtraction if carry	
	btfsc	VALUEI,7		; if set then negative so switch off
	goto	SWITCH_OFF	
	
; check if high enough

	movlw	H'00'
	subwf	CURRENT_H,w		; subtraction
	movwf	VALUEI			; keep subtraction
	movlw	D'4'			; low byte
	subwf	CURRENT_L,w		; subtraction
	btfss	STATUS,C
	decf	VALUEI,f		; reduce high byte subtraction if carry	
	btfsc	VALUEI,7		; if clear then positive so switch on
	goto	CYCLE	
	goto	SWITCH_ON

SWITCH_OFF
	clrf	SOFT			; soft flag cleared	
	clrf	RAMP
	bcf		GPIO,0			; ensure Mosfet is off

	call	DELAYms			; ~20ms 
	bcf		GPIO,5			; relay off
	goto	CYCLE

SWITCH_ON	; when current high enough, allow soft start
	bsf		SOFT,0
	goto	CYCLE			; Mosfet kept off after soft start has run to reduce circuitry current draw 

; *****************************************************************************************************************************************************

; subroutines

; subroutine to wait for A/D conversion
ACQUIRE_ADI	
	bsf		ADCON0,7	; current right justified
	goto	ACQUIRE_AD
ACQUIRE_ADP
	bcf		ADCON0,7	; smooth left justified
ACQUIRE_AD

	bsf		ADCON0,1	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,1	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
; ls byte in ADRESL (Bank 1)
; ms byte in ADRESH	(Bank 0)
	return

; delay loop 

DELAYms; approx 20ms
	movlw	D'30'		; delay value 
DEL_MORE
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'117'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAYX
	movlw	D'15'		; 
	movwf	STORE1		; STORE1 is  loop value	
LOOP1
	decfsz	STORE1,f
	goto	LOOP1
	return

; read data memory
READ
	bsf		STATUS,RP0	; select memory bank 1 
	movlw 	H'06'
	movwf 	PMADRH		; ms Byte of Program Address to read
	movlw	H'00'
	movwf 	PMADRL 		; ls Byte of Program Address to read

	bsf	 	PMCON1,RD 	; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
;	movf	PMDATH,w 	; ms Byte of Program data 
;	movwf	TEMP_VAL
	movf	PMDATL,w 	; ls Byte of Program data
	bcf		STATUS,RP0	; bank 0
	return
READ2
	bsf		STATUS,RP0	; select memory bank 1 
	movlw 	H'06'
	movwf 	PMADRH		; ms Byte of Program Address to read
	movlw	H'01'
	movwf 	PMADRL 		; ls Byte of Program Address to read

	bsf	 	PMCON1,RD 	; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
;	movf	PMDATH,w 	; ms Byte of Program data 
;	movwf	TEMP_VAL
	movf	PMDATL,w 	; ls Byte of Program data
	bcf		STATUS,RP0	; bank 0
	return

; write to data memory
WRITE
	bcf		INTCON,GIE ; Disable interrupts
CLR	btfsc	INTCON,GIE ; See AN576
	goto	CLR

	bsf		STATUS,RP0	; select memory bank 1
	movlw 	H'06'
	movwf 	PMADRH		; MS Byte of Program Address to write
	movlw	H'00'
	movwf 	PMADRL 		; LS Byte of Program Address to write

	movlw	H'78'		; Load initial data address
	movwf	FSR 
LOOP_WRITE 
	movf	 INDF,w 	; Load first data byte into upper byte
	movwf	 PMDATH		;
	incf	 FSR,f 		; Next byte
	movf	 INDF,w 	; Load second data byte into lower byte
	movwf	 PMDATL 		; 		
	incf	 FSR,f 			;
	bsf		 PMCON1,WREN ; Enable writes

; Required Sequence
	movlw	H'55'		; Start of required write sequence:
	movwf	PMCON2		; Write 55h
	movlw	H'AA'		;
	movwf	PMCON2 		; Write AAh
	bsf		PMCON1,WR 	; Set WR bit to begin write
	nop					; NOPs required for time to transfer data to the buffer registers
	nop					; 
;
	bcf		PMCON1,WREN ; Disable writes
	movf	PMADRL,w
	incf	PMADRL,f		; Increment address
; select 4,8,12 or16 	
	; 0F = 16 words
	; 0B = 12 words
	; 07 =  8 words
	; 03 =  4 words
	andlw	H'03'			; Indicates when the set number of words have been programmed
	sublw	H'03'

	btfss	STATUS,Z 		; Exit on a match,
	goto	LOOP_WRITE	; Continue until ended
	bcf		STATUS,RP0	; bank 0
;bsf		INTCON,GIE 	; enable interrupts 
	return


	end